﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Xml;

namespace PI.ZB.N1200.ELearning.WebApplication.Accounts
{
    public partial class Administration : BaseComponent
    {
        protected class StudentEditPanel : AdminPanel
        {
            public StudentEditPanel(Administration Component) : base(Component) { }

            private BL.BO.Student _Student = null;

            protected BL.BO.Student Student
            {
                get
                {
                    if (_Student == null)
                    {
                        if (StudentID.HasValue && StudentID > 0)
                        {
                            _Student = Component.BLELearning.Student.Restore(StudentID);
                        }
                        else
                        {
                            _Student = Component.BLELearning.Student.New();                            
                        }
                    }
                    
                    return _Student;
                }
            }

            public override void Load()
            {
                if (Student != null && Component.Instructor != null)
                {
                    Component.AppendToXML(Student);
                    Component.AppendToXML(Component.BLELearning.StudentDoc.Restore(Student));
                    BL.BO.Class _class = Component.BLELearning.Class.Restore(Student);
                    Component.AppendToXML(_class);
                    if (_class != null)
                    {
                        Component.AppendToXML(Component.BLELearning.School.Restore(_class.SchoolID));
                    }
                    // lista klas nauczyciela -  potrzebne przy edycji i wstawianiu
                    Component.XML.Element.Start("ClassList");
                    List<BL.BO.Class> _listClass = Component.BLELearning.Class.Restore(Component.Instructor);
                    foreach (BL.BO.Class _loopClass in _listClass)
                    {
                        Component.AppendToXML(_loopClass);
                    }
                    Component.XML.Element.End();
                }
            }

            public override bool Save()
            {
                if (Component.Instructor != null)
                {
                    switch (EditMode)
                    {
                        case EditModeType.EditOrInsert:
                            string _password = Component.Environment.GetRequestParamString("Student_Password");
                            string _passwordRe = Component.Environment.GetRequestParamString("Student_PasswordRe");

                            Student.Email = Component.Environment.GetRequestParamString("Student_Email");
                            Student.Forename = Component.Environment.GetRequestParamString("Student_Forename");
                            Student.Surename = Component.Environment.GetRequestParamString("Student_Surename");
                            Student.IndexNr = Component.Environment.GetRequestParamInt("Student_IndexNr");
                            Student.Sex = Component.Environment.GetRequestParamInt("Student_Sex") == 1;
                            Student.ClassID = Component.Environment.GetRequestParamLong("Student_ClassID");
                            if (!string.IsNullOrEmpty(_password))
                            {
                                if (_password != _passwordRe)
                                {
                                    Component.MethodResult.Add("Hasło nie zostało poprawnie powtórzone.", false);
                                    break;
                                }
                                Student.TmpPassword = _password;
                            }

                            if (string.IsNullOrEmpty(Student.Forename))
                            {
                                Component.MethodResult.Add("Pole 'Imie' nie może być puste.", false);
                            }

                            if (string.IsNullOrEmpty(Student.Surename))
                            {
                                Component.MethodResult.Add("Pole 'Nazwisko' nie może być puste.", false);
                            }

                            if (string.IsNullOrEmpty(Student.Email))
                            {
                                Component.MethodResult.Add("Pole 'Email' nie może być puste.", false);
                            }


                            if (Component.MethodResult.Success)
                            {
                                Component.MethodResult.Add(Component.BLELearning.Student.Save(Student));
                            }
                            break;

                        case EditModeType.Remove:
                            if (Student != null && Student.ID.HasValue)
                            {
                                Component.MethodResult.Add(Component.BLELearning.Student.Remove(Student));
                                Component.AdministrationArea = AdministrationAreaType.StudentList;
                            }
                            break;
                        case EditModeType.GenerateCertificate:
                            if (Student != null && Student.ID.HasValue)
                            {
                                PI.ZB.N1200.ELearning.BL.PDFReport.GenerateStudentCert(Student, Component.Environment);
                                Component.MethodResult.SetSuccess = true;
                            }
                            break;
                    }
                }
                return Component.MethodResult.Success;
            }
        }
    }
}
